# Jail Creation Profiles

## Description

If you work in a smaller environment where full configuration management tools might be overkill, but you frequently create jails with non-default options, you can use the jail profiles included with **CBSD**. You can either use the existing profiles or create your own in **$workdir/etc/**.

First, examine the contents of [$workdir/etc/defaults/jail-freebsd-default.conf](../../../etc/defaults/jail-freebsd-default.conf). This file contains the default profile settings used by the **jconstruct-tui** command.

## Creating a Custom Default Profile

Let's say you want to modify the default jail profile with these settings:
- Writable jail base system (`baserw=1` instead of default `baserw=0`)
- Use interface `lo0` (instead of `auto`)
- Default name `cell` instead of `jail`
- Domain `example.com`
- Launch jail immediately after creation (`runasap="1"`)

Create a profile in **$workdir/etc/** named **jail-freebsd-default.conf**:

```sh
echo 'baserw="1"' > ~cbsd/etc/jail-freebsd-default.conf
echo 'interface="lo0"' >> ~cbsd/etc/jail-freebsd-default.conf
echo 'default_jailname="cell"' >> ~cbsd/etc/jail-freebsd-default.conf
echo 'default_domain="example.com"' >> ~cbsd/etc/jail-freebsd-default.conf
echo 'runasap="1"' >> ~cbsd/etc/jail-freebsd-default.conf
```

The resulting file **$workdir/etc/jail-freebsd-default.conf** will contain:

```
baserw="1"
interface="lo0"
default_jailname="cell"
default_domain="example.com"
runasap="1"
```

Now when you run **cbsd jconstruct-tui**, your custom settings will be applied when using the  default profile.

## Creating Multiple Profiles

You can create several custom jail profiles. Create files in **~cbsd/etc/** with the prefix: **jail-freebsd-YOUR_PROFILE.conf**.

To make a profile appear in the 'profile' dialog of **CBSD jconstruct-tui**, define the `jail_profile="YOUR_PROFILE"` variable. For example, let's create two profiles: **baserw** and **lo0**:

```sh
echo 'jail_profile="baserw"' > ~cbsd/etc/jail-freebsd-baserw.conf
echo 'baserw="1"' >> ~cbsd/etc/jail-freebsd-baserw.conf
```

```sh
echo 'jail_profile="lo0"' > ~cbsd/etc/jail-freebsd-lo0.conf
echo 'interface="lo0"' >> ~cbsd/etc/jail-freebsd-lo0.conf
```

These new profiles will now appear in the available options for the 'profile' dialog in **cbsd jconstruct-tui**.

## Setting an Alternative Default Profile

If you want to make the lo0 profile your default, override the settings in **$workdir/etc/jail-freebsd-default.conf** by setting the `default_profile` variable:

```sh
echo 'default_profile="lo0"' > ~cbsd/etc/jail-freebsd-default.conf
```

The file **~cbsd/etc/jail-freebsd-default.conf** will now contain:
```
default_profile="lo0"
```

When you run **cbsd jconstruct-tui**, the lo0 profile settings will be selected by default.

## Jail Profile Contents

### Description

When you need to create multiple similar jails with specific software and configuration (for example, an nginx web server with a custom index.html), you have several options:

1. Create a jail, configure it, and use **jexport**
2. Use **jclone** to create new instances
3. Use alternative **skel**-directories to apply changes during jail creation

### Example: Creating an Nginx Jail Profile

1. **Create or Export a jconf File**

You can create a template in two ways:
- Run **cbsd jconstruct-tui** and select **NO** when asked to create the jail immediately. (This will cause the template file to be written to **\$workdir/ftmp**).
- Manually create a new **jconf** file

Here's an example **jconf** file:

```sh
mkdir /root/share
cat > /root/share/nginx.jconf << EOF
# DO NOT EDIT THIS FILE. PLEASE USE INSTEAD:
# cbsd jconfig jname=jail1
relative_path="1";
jname="jail1";
path="/usr/jails/jails/jail1";
host_hostname="jail1.my.domain";
ip4_addr="DHCP";
mount_devfs="1";
allow_mount="1";
allow_devfs="1";
allow_nullfs="1";
mount_fstab="/usr/jails/jails-fstab/fstab.jail1";
arch="native";
mkhostsfile="1";
devfs_ruleset="4";
ver="native";
basename="";
baserw="0";
mount_src="0";
mount_obj="0";
mount_kernel="0";
mount_ports="1";
astart="1";
data="/usr/jails/jails-data/jail1-data";
vnet="0";
applytpl="1";
mdsize="0";
rcconf="/usr/jails/jails-rcconf/rc.conf_jail1";
floatresolv="1";
zfs_snapsrc="";

exec_poststart="0";
exec_poststop="";
exec_prestart="0";
exec_prestop="0";

exec_master_poststart="0";
exec_master_poststop="0";
exec_master_prestart="0";
exec_master_prestop="0";
pkg_bootstrap="1";
pkglist="/root/share/pkglist.txt";

with_img_helpers="";
runasap="0";
interface="auto";
jailskeldir="/root/share/nginx-jail"
jail_profile="default";
# root password
user_pw_root='rootpw'
exec_start="/bin/sh /etc/rc"
exec_stop="/bin/sh /etc/rc.shutdown"
emulator="jail"
EOF
```

Key variables to consider:
- `jail1` - jail name
- `user_pw_root` - sets the root password
- `ip4_addr="DHCP"` - assigns the first free IP from nodepool
- `jailskeldir="/root/share/nginx-jail"` - path to alternative skel directory
- `pkglist="/root/share/pkglist.txt"` - path to package list file
- `arch="native"` - use 'hoster' to inherit host architecture or specify: i386, amd64
- `ver="native"` - use 'hoster' to inherit host version or specify: 10.3, 11.1, 12, etc.

2. **Create pkglist.txt**

List the software you want to install in the jail:

```sh
cat > /root/share/pkglist.txt << EOF
www/nginx
shells/bash
EOF
```

3. **Set Up skel-directories**

Configure additional files to copy into the jail:

```sh
cp -a /usr/local/cbsd/share/jail-skel /root/share/nginx-jail
mkdir -p /root/share/nginx-jail/usr/local/www/nginx
cat > /root/share/nginx-jail/usr/local/www/nginx/index.html << EOF
<html>
   <body>
      <pre>
      It's been a hard day's night
      And I've been working like a dog
      It's been a hard day's night
      I should be sleeping like a log
      </pre>
   </body>
</html>
EOF
sysrc -f /root/share/nginx-jail/etc/rc.conf nginx_enable="YES"
```

4. **Create and Launch**

Create the new environment and test it:

```sh
cbsd jcreate jconf=/root/share/nginx.jconf
cbsd jstart jail1
curl http://X.Y.N.M
```

## Best Practices

1. Avoid modifying files in **$workdir/etc/defaults** directly
2. Copy files from **$workdir/etc/defaults** to **$workdir/etc** before modifying
3. Keep the original default files intact for reference
4. Use clear, descriptive profile names
5. Document your custom profiles

This approach maintains the original default values while allowing you to override them as needed, similar to how FreeBSD handles [system configuration](https://man.freebsd.org/cgi/man.cgi?query=rc.conf&sektion=5&format=html) in **/etc/defaults** and **/etc**.
