
/* sys/ttycom.h tty(4) */
IOCTL(TIOCSETD, IOC_W, MK_PTR(TYPE_INT))
IOCTL(TIOCGETD, IOC_R, MK_PTR(TYPE_INT))
IOCTL(TIOCSBRK, IOC_, TYPE_NULL)
IOCTL(TIOCCBRK, IOC_, TYPE_NULL)
IOCTL(TIOCSDTR, IOC_, TYPE_NULL)
IOCTL(TIOCCDTR, IOC_, TYPE_NULL)
IOCTL(TIOCGPGRP, IOC_R, MK_PTR(TYPE_INT))
IOCTL(TIOCSPGRP, IOC_W, MK_PTR(TYPE_INT))
IOCTL(TIOCGETA, IOC_R, MK_PTR(MK_STRUCT(STRUCT_termios)))
IOCTL(TIOCSETA, IOC_W, MK_PTR(MK_STRUCT(STRUCT_termios)))
IOCTL(TIOCSETAW, IOC_W, MK_PTR(MK_STRUCT(STRUCT_termios)))
IOCTL(TIOCSETAF, IOC_W, MK_PTR(MK_STRUCT(STRUCT_termios)))
IOCTL(TIOCPTMASTER, IOC_, TYPE_NULL)
IOCTL(TIOCOUTQ, IOC_R, MK_PTR(TYPE_INT))
IOCTL(TIOCSTI, IOC_W, MK_PTR(TYPE_CHAR))
IOCTL(TIOCNOTTY, IOC_, TYPE_NULL)
IOCTL(TIOCSTOP, IOC_, TYPE_NULL)
IOCTL(TIOCSTART, IOC_, TYPE_NULL)
IOCTL(TIOCPKT, IOC_W, MK_PTR(TYPE_INT))
IOCTL(TIOCSCTTY, IOC_, TYPE_NULL)
IOCTL(TIOCDRAIN, IOC_, TYPE_NULL)
IOCTL(TIOCEXCL, IOC_, TYPE_NULL)
IOCTL(TIOCNXCL, IOC_, TYPE_NULL)
IOCTL(TIOCFLUSH, IOC_W, MK_PTR(TYPE_INT))
IOCTL(TIOCGWINSZ, IOC_R, MK_PTR(MK_STRUCT(STRUCT_winsize)))
IOCTL(TIOCSWINSZ, IOC_W, MK_PTR(MK_STRUCT(STRUCT_winsize)))
IOCTL(TIOCCONS, IOC_W, MK_PTR(TYPE_INT))
IOCTL(TIOCMSET, IOC_W, MK_PTR(TYPE_INT))
IOCTL(TIOCMGET, IOC_R, MK_PTR(TYPE_INT))
IOCTL(TIOCMBIS, IOC_W, MK_PTR(TYPE_INT))
IOCTL(TIOCMBIC, IOC_W, MK_PTR(TYPE_INT))

/* sys/filio.h */
IOCTL(FIOCLEX, IOC_, TYPE_NULL)
IOCTL(FIONCLEX, IOC_, TYPE_NULL)
IOCTL(FIONREAD, IOC_R, MK_PTR(TYPE_INT))
IOCTL(FIONBIO, IOC_W, MK_PTR(TYPE_INT))
IOCTL(FIOASYNC, IOC_W, MK_PTR(TYPE_INT))
IOCTL(FIOSETOWN, IOC_W, MK_PTR(TYPE_INT))
IOCTL(FIOGETOWN, IOC_R, MK_PTR(TYPE_INT))
IOCTL(FIODTYPE, IOC_R, MK_PTR(TYPE_INT))
IOCTL(FIOGETLBA, IOC_R, MK_PTR(TYPE_INT))
IOCTL(FIODGNAME, IOC_W, MK_PTR(MK_STRUCT(STRUCT_fiodgname_arg)))
IOCTL(FIONWRITE, IOC_R, MK_PTR(TYPE_INT))
IOCTL(FIONSPACE, IOC_R, MK_PTR(TYPE_INT))
IOCTL(FIOSEEKDATA, IOC_RW, MK_PTR(TYPE_ULONG))
IOCTL(FIOSEEKHOLE, IOC_RW, MK_PTR(TYPE_ULONG))

/* crypto/cryptodev.h */
IOCTL_SPECIAL(CIOCGSESSION, IOC_RW, do_ioctl_unsupported, TYPE_INT)
IOCTL_SPECIAL_UNIMPL(CRIOGET, IOC_RW, do_ioctl_unsupported, TYPE_INT)

/* netinet6/in6_var.h */
IOCTL_SPECIAL(SIOCGIFAFLAG_IN6, IOC_RW, do_ioctl_in6_ifreq_sockaddr_int, MK_PTR(MK_STRUCT(STRUCT_in6_ifreq_int)))
IOCTL_SPECIAL(SIOCGIFALIFETIME_IN6, IOC_RW, do_ioctl_in6_ifreq_sockaddr_int, MK_PTR(MK_STRUCT(STRUCT_in6_ifreq_int)))
IOCTL(SIOCGIFPSRCADDR_IN6, IOC_RW, MK_PTR(MK_STRUCT(STRUCT_in6_ifreq_sockaddr_in6)))
IOCTL(SIOCGIFINFO_IN6, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_in6_ndireq)))
IOCTL(SIOCGDEFIFACE_IN6, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_in6_ndifreq)))

/* sys/disk.h */
IOCTL(DIOCGSECTORSIZE, IOC_R, MK_PTR(TYPE_INT))
IOCTL(DIOCGMEDIASIZE, IOC_R, MK_PTR(TYPE_LONGLONG))

/* sys/sockio.h */
IOCTL_SPECIAL(SIOCGIFMAC, IOC_RW, do_ioctl_unsupported, MK_PTR(MK_STRUCT(STRUCT_ifreq_int)))

IOCTL(SIOCGIFCONF, IOC_RW, MK_PTR(MK_STRUCT(STRUCT_ifconf)))

IOCTL(SIOCGIFFLAGS, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifreq_short)))
IOCTL(SIOCSIFFLAGS, IOC_W, MK_PTR(MK_STRUCT(STRUCT_ifreq_short)))

IOCTL(SIOCGIFMETRIC, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifreq_int)))
IOCTL(SIOCSIFMETRIC, IOC_W, MK_PTR(MK_STRUCT(STRUCT_ifreq_int)))
IOCTL(SIOCGIFMTU, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifreq_int)))
IOCTL(SIOCSIFMTU, IOC_W, MK_PTR(MK_STRUCT(STRUCT_ifreq_int)))
IOCTL(SIOCGIFINDEX, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifreq_int)))
IOCTL(SIOCGIFFIB, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifreq_int)))
#ifdef SIOCGTUNFIB
IOCTL(SIOCGTUNFIB, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifreq_int)))
#endif

IOCTL(SIOCGIFCAP, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifreq_cap)))

IOCTL(SIOCGIFADDR, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifreq_sockaddr)))
IOCTL(SIOCSIFADDR, IOC_W, MK_PTR(MK_STRUCT(STRUCT_ifreq_sockaddr)))
IOCTL(SIOCGIFBRDADDR, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifreq_sockaddr)))
IOCTL(SIOCSIFBRDADDR, IOC_W, MK_PTR(MK_STRUCT(STRUCT_ifreq_sockaddr)))
IOCTL(SIOCGIFDSTADDR, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifreq_sockaddr)))
IOCTL(SIOCSIFDSTADDR, IOC_W, MK_PTR(MK_STRUCT(STRUCT_ifreq_sockaddr)))
IOCTL(SIOCGIFNETMASK, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifreq_sockaddr)))
IOCTL(SIOCSIFNETMASK, IOC_W, MK_PTR(MK_STRUCT(STRUCT_ifreq_sockaddr)))
IOCTL(SIOCADDMULTI, IOC_W, MK_PTR(MK_STRUCT(STRUCT_ifreq_sockaddr)))
IOCTL(SIOCDELMULTI, IOC_W, MK_PTR(MK_STRUCT(STRUCT_ifreq_sockaddr)))
IOCTL(SIOCGIFPSRCADDR, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifreq_sockaddr)))

IOCTL(SIOCGIFGENERIC, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifreq_ptr)))

IOCTL(SIOCGIFDESCR, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifreq_buf)))

IOCTL(SIOCGDRVSPEC, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifdrv)))

IOCTL(SIOCGIFGROUP, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifgroupreq_ptr)))

IOCTL(SIOCGIFMEDIA, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifmediareq)))
#ifdef SIOCGIFXMEDIA
IOCTL(SIOCGIFXMEDIA, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifmediareq)))
#endif

IOCTL(SIOCGIFSTATUS, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifstat)))

/* net/if_gre.h */
IOCTL(GREGKEY, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifreq_ptr)))
#ifdef GREGOPTS
IOCTL(GREGOPTS, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifreq_ptr)))
#endif

/* net/if_gif.h */
IOCTL(GIFGOPTS, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifreq_ptr)))

/* netinet/ip_carp.h */
IOCTL(SIOCGVH, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifreq_ptr)))

/* net/if_pfsync.h */
#ifdef SIOCGETPFSYNC
IOCTL(SIOCGETPFSYNC, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ifreq_ptr)))
#endif

/* net80211/ieee80211_ioctl.h */
IOCTL(SIOCG80211, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_ieee80211req)))

/* net/if_lagg.h */
IOCTL(SIOCGLAGGPORT, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_lagg_reqport_lacp_opreq)))
IOCTL(SIOCGLAGG, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_lagg_reqall_lacp_opreq)))
IOCTL(SIOCGLAGGFLAGS, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_lagg_reqflags)))
#ifdef SIOCGLAGGOPTS
IOCTL(SIOCGLAGGOPTS, IOC_W | IOC_R, MK_PTR(MK_STRUCT(STRUCT_lagg_reqopts)))
#endif

